@extends('layouts.landing.app')

@section('title', translate('messages.contact_us'))

@section('content')
    <!-- ==== Contact Section ==== -->
    <section class="about-section py-5 position-relative">
        <div class=" container contact-container">
            <div class="section-header">
                @php($contact_us_title = \App\Models\DataSetting::where(['key' => 'contact_us_title'])->first())
                @php($contact_us_title = isset($contact_us_title->value) ? $contact_us_title->value : null)
                @php($contact_us_sub_title = \App\Models\DataSetting::where(['key' => 'contact_us_sub_title'])->first())
                @php($contact_us_sub_title = isset($contact_us_sub_title->value) ? $contact_us_sub_title->value : null)
                @php($contact_us_image = \App\Models\DataSetting::where(['key' => 'contact_us_image'])->first())
{{--                @php($contact_us_image = isset($contact_us_image->value) ? $contact_us_image->value : null)--}}
                <h2 class="title mb-2">{{$contact_us_title}}</h2>
                <div class="text">{{$contact_us_sub_title}}</div>
            </div>
            @php($landing_page_images = \app\CentralLogics\Helpers::get_business_settings('landing_page_images'))
            @php($landing_page_images_value = isset($landing_page_images) ? $landing_page_images :null)
            <div class="contact-img">
                <img src="{{\App\CentralLogics\Helpers::get_full_url('contact_us_image',$contact_us_image?->value,$contact_us_image?->storage[0]?->value ?? 'public')}}" alt="">
            </div>
            <div class="row gy-5 mt-0">
                <div class="col-lg-6">
                    <div class="row g-4">
                        <div class="col-sm-6">
                            <div class="contact-item">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="icon">
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect width="60" height="60" rx="20" fill="url(#paint0_linear_28_2312)" />
                                            <path
                                                d="M33 20.5116C33.0495 20.3306 33.1682 20.1763 33.3304 20.0821C33.4926 19.9878 33.6854 19.9611 33.8672 20.0077C35.5751 20.4668 37.1323 21.3666 38.3828 22.6171C39.6333 23.8676 40.5331 25.4248 40.9922 27.1327C41.0169 27.2227 41.0234 27.3168 41.0114 27.4094C40.9993 27.502 40.969 27.5912 40.922 27.672C40.8751 27.7527 40.8126 27.8232 40.7381 27.8796C40.6637 27.9359 40.5787 27.9768 40.4883 27.9999L40.3125 28.0233C40.1568 28.0231 40.0056 27.9712 39.8826 27.8757C39.7596 27.7803 39.6717 27.6467 39.6328 27.496C39.2354 26.0282 38.4605 24.69 37.3852 23.6147C36.3099 22.5394 34.9717 21.7645 33.5039 21.3671C33.3255 21.3175 33.1732 21.2007 33.0792 21.0411C32.9852 20.8815 32.9568 20.6917 33 20.5116ZM32.5313 24.9882C33.3637 25.2161 34.1224 25.6569 34.7327 26.2672C35.343 26.8775 35.7838 27.6362 36.0117 28.4686C36.0506 28.6194 36.1385 28.753 36.2615 28.8484C36.3845 28.9438 36.5357 28.9957 36.6914 28.996L36.8672 28.9726C37.0465 28.9205 37.1989 28.8013 37.2928 28.6399C37.3866 28.4784 37.4146 28.287 37.3711 28.1054C37.0816 27.0329 36.5158 26.0551 35.7303 25.2696C34.9448 24.4841 33.967 23.9183 32.8945 23.6288C32.7129 23.5852 32.5215 23.6133 32.36 23.7071C32.1986 23.801 32.0794 23.9534 32.0273 24.1327C31.981 24.313 32.0081 24.5042 32.1025 24.6646C32.197 24.8249 32.3511 24.9413 32.5313 24.9882ZM41.9063 36.4843C41.7098 38.0119 40.964 39.4158 39.8081 40.4337C38.6521 41.4516 37.1652 42.0139 35.625 42.0155C26.4492 42.0155 18.9844 34.5507 18.9844 25.3749C18.986 23.8347 19.5483 22.3478 20.5662 21.1918C21.5841 20.0359 22.988 19.2901 24.5156 19.0936C24.8671 19.0525 25.2225 19.1261 25.5288 19.3035C25.835 19.4809 26.0757 19.7526 26.2148 20.078L28.5703 25.5741C28.6772 25.8228 28.7213 26.0939 28.6988 26.3636C28.6763 26.6334 28.5879 26.8934 28.4414 27.121L26.4844 30.0976C26.465 30.1311 26.4539 30.1688 26.4519 30.2075C26.4498 30.2462 26.4569 30.2848 26.4727 30.3202C27.3728 32.1658 28.8668 33.6556 30.7148 34.5507C30.7507 34.5668 30.7902 34.5731 30.8293 34.569C30.8684 34.5649 30.9058 34.5505 30.9375 34.5272L33.8789 32.5702C34.1042 32.4188 34.364 32.3266 34.6344 32.302C34.9047 32.2775 35.1769 32.3213 35.4258 32.4296L40.9219 34.7851C41.2473 34.9242 41.519 35.1649 41.6964 35.4711C41.8738 35.7774 41.9474 36.1328 41.9063 36.4843ZM40.5117 36.3085C40.5157 36.2596 40.5043 36.2107 40.4791 36.1687C40.4539 36.1266 40.4161 36.0936 40.3711 36.0741L34.875 33.7186C34.8387 33.7047 34.7996 33.6995 34.7609 33.7036C34.7221 33.7077 34.685 33.7209 34.6523 33.7421L31.7227 35.6991C31.4855 35.8549 31.2124 35.9475 30.9293 35.968C30.6462 35.9885 30.3627 35.9363 30.1055 35.8163C27.9739 34.7786 26.2499 33.0587 25.207 30.9296C25.0852 30.6755 25.031 30.3942 25.0494 30.113C25.0679 29.8318 25.1585 29.5601 25.3125 29.3241L27.2578 26.3476C27.281 26.3158 27.2954 26.2785 27.2996 26.2394C27.3037 26.2003 27.2974 26.1608 27.2813 26.1249L24.9258 20.6288C24.9078 20.5876 24.8784 20.5524 24.841 20.5275C24.8036 20.5026 24.7598 20.4889 24.7148 20.4882H24.6914C23.5045 20.6442 22.4145 21.2255 21.6236 22.1241C20.8327 23.0228 20.3946 24.1778 20.3906 25.3749C20.3937 29.4144 21.9998 33.2875 24.8561 36.1438C27.7124 39.0001 31.5855 40.6062 35.625 40.6093C36.8221 40.6053 37.9771 40.1672 38.8758 39.3763C39.7744 38.5854 40.3557 37.4954 40.5117 36.3085Z"
                                                fill="white" />
                                            <defs>
                                                <linearGradient id="paint0_linear_28_2312" x1="30" y1="0" x2="30"
                                                    y2="60" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#85F390" />
                                                    <stop offset="1" stop-color="#02B714" />
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    </div>
                                    <h5 class="subtitle">{{translate("messages.Call_Us")}} </h5>
                                </div>
                                <ul>
                                    <li>
                                        <a href="tel:{{ \App\CentralLogics\Helpers::get_settings('phone') }}">{{ \App\CentralLogics\Helpers::get_settings('phone') }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="contact-item">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="icon">
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect width="60" height="60" rx="20" fill="url(#paint0_linear_247_418)" />
                                            <path
                                                d="M18.75 22.5L28.75 28.75L38.75 22.5V26.25H41.25V20C41.25 18.625 40.125 17.5 38.75 17.5H18.75C17.375 17.5 16.2625 18.625 16.2625 20L16.25 35C16.25 36.375 17.375 37.5 18.75 37.5H31.25V35H18.75V22.5ZM38.75 20L28.75 26.25L18.75 20H38.75Z"
                                                fill="white" />
                                            <path
                                                d="M41.25 32.5V37.5C41.25 38.875 40.125 40 38.75 40C37.375 40 36.25 38.875 36.25 37.5V31.875C36.25 31.525 36.525 31.25 36.875 31.25C37.225 31.25 37.5 31.525 37.5 31.875V37.5H40V31.875C40 31.0462 39.6708 30.2513 39.0847 29.6653C38.4987 29.0792 37.7038 28.75 36.875 28.75C36.0462 28.75 35.2513 29.0792 34.6653 29.6653C34.0792 30.2513 33.75 31.0462 33.75 31.875V37.5C33.75 40.2625 35.9875 42.5 38.75 42.5C41.5125 42.5 43.75 40.2625 43.75 37.5V32.5H41.25Z"
                                                fill="white" />
                                            <defs>
                                                <linearGradient id="paint0_linear_247_418" x1="30" y1="0" x2="30"
                                                    y2="60" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#85F390" />
                                                    <stop offset="1" stop-color="#02B714" />
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    </div>
                                    <h5 class="subtitle">{{translate("messages.Email")}}</h5>
                                </div>
                                <ul>
                                    <li>
                                        <a href="Malto:{{ \App\CentralLogics\Helpers::get_settings('email_address') }}">{{ \App\CentralLogics\Helpers::get_settings('email_address') }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="contact-item">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="icon">
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect width="60" height="60" rx="20" fill="url(#paint0_linear_28_2295)" />
                                            <path
                                                d="M30 31.25C32.0711 31.25 33.75 29.5711 33.75 27.5C33.75 25.4289 32.0711 23.75 30 23.75C27.9289 23.75 26.25 25.4289 26.25 27.5C26.25 29.5711 27.9289 31.25 30 31.25Z"
                                                stroke="white" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M30 17.5C27.3478 17.5 24.8043 18.5536 22.9289 20.4289C21.0536 22.3043 20 24.8478 20 27.5C20 29.865 20.5025 31.4125 21.875 33.125L30 42.5L38.125 33.125C39.4975 31.4125 40 29.865 40 27.5C40 24.8478 38.9464 22.3043 37.0711 20.4289C35.1957 18.5536 32.6522 17.5 30 17.5V17.5Z"
                                                stroke="white" stroke-width="2" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <defs>
                                                <linearGradient id="paint0_linear_28_2295" x1="30" y1="0" x2="30"
                                                    y2="60" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#85F390" />
                                                    <stop offset="1" stop-color="#02B714" />
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    </div>
                                    <h5 class="subtitle">{{translate("messages.Address")}}</h5>
                                </div>
                                <ul>
                                    <li>

                                        @php($default_location = \App\CentralLogics\Helpers::get_settings('default_location'))

                                        <a href="https://www.google.com/maps/search/?api=1&query={{ data_get($default_location,'lat',0)}},{{ data_get($default_location,'lng',0)}}" target="_blank">{{ \App\CentralLogics\Helpers::get_settings('address') }}</a>

                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="contact-item">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="icon">
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect width="60" height="60" rx="20" fill="url(#paint0_linear_28_2325)" />
                                            <g clip-path="url(#clip0_28_2325)">
                                                <path
                                                    d="M30.9656 16.9106C30.6443 16.8869 30.3222 16.875 30 16.875V15C30.3685 15.0002 30.7369 15.0139 31.1044 15.0412L30.9656 16.9106ZM34.7231 17.7544C34.1221 17.5224 33.5048 17.3351 32.8763 17.1937L33.2869 15.3637C34.005 15.525 34.7119 15.7387 35.3981 16.005L34.7231 17.7544ZM37.2919 19.0856C37.0238 18.9068 36.7492 18.738 36.4687 18.5794L37.3931 16.9481C38.0342 17.3114 38.6477 17.7212 39.2288 18.1744L38.0756 19.6537C37.8214 19.4554 37.56 19.2666 37.2919 19.0875V19.0856ZM40.7306 22.4419C40.3597 21.915 39.9505 21.4161 39.5062 20.9494L40.8637 19.6556C41.37 20.19 41.8388 20.7619 42.2644 21.3619L40.7306 22.4419ZM42.1256 24.9769C42.0026 24.6796 41.8687 24.3869 41.7244 24.0994L43.3988 23.2556C43.7299 23.9139 44.0119 24.5958 44.2425 25.2956L42.4613 25.8825C42.3605 25.5766 42.2485 25.2745 42.1256 24.9769ZM43.1194 29.6775C43.1042 29.0331 43.0415 28.3908 42.9319 27.7556L44.7787 27.4369C44.9044 28.1606 44.9775 28.8956 44.9963 29.6306L43.1213 29.6775H43.1194ZM42.8738 32.5612C42.9356 32.2425 42.9862 31.9256 43.0256 31.605L44.8875 31.8356C44.7974 32.5672 44.6533 33.291 44.4563 34.0012L42.6488 33.5006C42.735 33.1912 42.81 32.8781 42.8738 32.5612ZM41.0887 37.0219C41.4337 36.4781 41.7375 35.9081 42 35.3194L43.7137 36.0787C43.4138 36.7537 43.0669 37.4025 42.6731 38.025L41.0887 37.0219ZM39.2812 39.2812C39.51 39.0525 39.7294 38.8162 39.9375 38.5725L41.3587 39.7969C41.1181 40.0759 40.8673 40.3461 40.6069 40.6069L39.2812 39.2812Z"
                                                    fill="white" />
                                                <path
                                                    d="M30 16.875C27.8416 16.8752 25.7166 17.4076 23.8132 18.4251C21.9098 19.4427 20.2866 20.9139 19.0876 22.7086C17.8886 24.5032 17.1506 26.5659 16.9391 28.7139C16.7276 30.8618 17.0491 33.0288 17.8751 35.0228C18.7011 37.0169 20.0061 38.7765 21.6745 40.1457C23.3429 41.515 25.3233 42.4516 27.4401 42.8728C29.557 43.2939 31.745 43.1864 33.8105 42.56C35.8759 41.9335 37.755 40.8074 39.2812 39.2812L40.6069 40.6069C38.8626 42.3521 36.7148 43.6401 34.3538 44.3569C31.9928 45.0736 29.4914 45.1969 27.0714 44.7159C24.6513 44.2349 22.3872 43.1643 20.4798 41.5992C18.5723 40.034 17.0804 38.0225 16.1361 35.7429C15.1919 33.4633 14.8245 30.986 15.0665 28.5305C15.3085 26.075 16.1524 23.7171 17.5235 21.6657C18.8946 19.6143 20.7505 17.9327 22.9268 16.77C25.1031 15.6073 27.5326 14.9993 30 15V16.875Z"
                                                    fill="white" />
                                                <path
                                                    d="M29.0625 20.625C29.3111 20.625 29.5496 20.7238 29.7254 20.8996C29.9012 21.0754 30 21.3139 30 21.5625V31.3313L36.09 34.8113C36.2996 34.9377 36.4514 35.1411 36.5131 35.378C36.5747 35.615 36.5412 35.8666 36.4197 36.0791C36.2983 36.2917 36.0985 36.4483 35.8631 36.5155C35.6277 36.5827 35.3754 36.5551 35.16 36.4388L28.5975 32.6888C28.454 32.6068 28.3347 32.4884 28.2518 32.3455C28.1688 32.2025 28.1251 32.0402 28.125 31.875V21.5625C28.125 21.3139 28.2238 21.0754 28.3996 20.8996C28.5754 20.7238 28.8139 20.625 29.0625 20.625Z"
                                                    fill="white" />
                                            </g>
                                            <defs>
                                                <linearGradient id="paint0_linear_28_2325" x1="30" y1="0" x2="30"
                                                    y2="60" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#85F390" />
                                                    <stop offset="1" stop-color="#02B714" />
                                                </linearGradient>
                                                <clipPath id="clip0_28_2325">
                                                    <rect x="15" y="15" width="30" height="30" rx="15" fill="white" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                    <h5 class="subtitle">{{translate("messages.Time")}}</h5>
                                </div>
                                <ul>
                                    <li>
                                        {{translate(\App\CentralLogics\Helpers::get_settings('opening_day'))}}- {{translate(\App\CentralLogics\Helpers::get_settings('closing_day'))}}
                                    </li>
                                    <li>
                                        {{\App\CentralLogics\Helpers::time_format(\App\CentralLogics\Helpers::get_settings('opening_time')) }}- {{ \App\CentralLogics\Helpers::time_format( \App\CentralLogics\Helpers::get_settings('closing_time'))}}
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <form class="contact-form-wrapper" method="post" action="{{route('send-message')}}" id="form-id">
                        @csrf
                        <div class="row g-4">
                            <div class="col-sm-6">
                                <input type="text" required name="name" placeholder="{{ translate('Your Name') }}" class="form-control form--control">
                            </div>
                            <div class="col-sm-6">
                                <input type="email" required name="email" placeholder="{{ translate('Email') }}" class="form-control form--control">
                            </div>
                            <div class="col-sm-12">
                                <input type="text" required name="subject" placeholder="{{ translate('Subject') }}" class="form-control form--control">
                            </div>
                            <div class="col-sm-12">
                                <textarea name="message" required class="form-control form--control" placeholder="Message"></textarea>
                            </div>
                            @php($recaptcha = \App\CentralLogics\Helpers::get_business_settings('recaptcha'))
                            @if(isset($recaptcha) && $recaptcha['status'] == 1)
                                <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response">
                            @else
                                <div class="m-auto p-3 row" id="reload-captcha">
                                    <div class="col-6 pr-0">
                                        <input type="text" class="form-control form-control-lg" name="custome_recaptcha"
                                               id="custome_recaptcha" required placeholder="{{translate('Enter recaptcha value')}}" autocomplete="off" value="{{env('APP_MODE')=='dev'? session('six_captcha'):''}}">
                                    </div>
                                    <div class="col-6 bg-white rounded d-flex w-auto">
                                        <img src="<?php echo $custome_recaptcha->inline(); ?>" class="rounded w-100" />
                                    </div>
                                </div>
                            @endif
                            <div class="col-sm-12 text-center">
                                <button class="cmn--btn border-0" type="submit" id="signInBtn">{{translate("messages.Send_Message")}} </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Left Shape -->
        <svg class="left--shape" width="172" height="555" viewBox="0 0 172 555" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <g opacity="0.19">
                <g opacity="0.3">
                    <path
                        d="M-3.57898 275.511C-1.58262 277.217 1.16599 277.815 3.78866 277.68C6.40444 277.539 8.94008 276.734 11.4221 275.898C16.8846 274.066 21.8903 272.326 27.1018 269.913C29.2526 268.917 31.7543 267.417 33.7839 266.192C34.4355 265.802 35.0896 265.38 35.5401 264.77C35.9906 264.16 36.2009 263.317 35.8811 262.632C35.5264 261.864 34.6014 261.488 33.7508 261.522C32.9064 261.556 32.1066 261.908 31.33 262.245C24.7947 265.062 17.6009 266.972 10.5715 265.848C8.60603 265.536 6.68694 264.987 4.73158 264.655C2.77008 264.324 0.728518 264.208 -1.18297 264.757C-3.09445 265.306 -4.86621 266.599 -5.61699 268.443C-6.60305 270.871 -5.57385 273.817 -3.57749 275.523L-3.57898 275.511Z"
                        fill="url(#paint0_linear_28_1933)" />
                    <path
                        d="M70.0672 346.078C69.9645 344.038 68.8331 342.158 67.3526 340.746C65.8728 339.339 64.0609 338.335 62.2542 337.373C58.2935 335.261 54.6263 333.357 50.4709 331.699C48.7537 331.014 46.5652 330.405 44.7895 329.907C44.2217 329.751 43.63 329.604 43.0458 329.675C42.4616 329.745 41.8717 330.078 41.6512 330.629C41.4073 331.245 41.6939 331.966 42.1613 332.427C42.6349 332.888 43.2591 333.15 43.8649 333.414C48.9584 335.607 53.893 338.656 57.0164 343.241C57.8883 344.521 58.61 345.9 59.4703 347.188C60.3307 348.476 61.3634 349.693 62.6938 350.481C64.0241 351.269 65.7084 351.578 67.1505 351.017C69.0574 350.275 70.1691 348.113 70.0664 346.072L70.0672 346.078Z"
                        fill="url(#paint1_linear_28_1933)" />
                    <path
                        d="M105.356 278.613C103.388 280.136 101.564 269.21 102.005 263.447C102.444 257.678 109.676 258.566 108.514 266.675C107.353 274.784 105.944 278.155 105.35 278.613L105.356 278.613Z"
                        fill="url(#paint2_linear_28_1933)" />
                    <path
                        d="M112.345 339.287C106.088 345.702 96.5098 348.841 87.752 346.94C80.8593 345.45 74.9596 341.176 68.8601 337.625C59.8684 332.388 50.0555 328.567 39.887 326.349C30.4353 324.282 16.9569 327.88 8.64159 322.923C3.18386 319.675 -1.26726 314.584 -3.17129 308.523C-5.55895 300.936 -2.81309 291.375 1.16305 286.427C9.2289 276.387 28.7197 275.515 38.4734 267.106C46.3733 260.293 47.1947 250.553 54.4009 243.006C60.4164 236.708 69.9708 234.145 78.3947 236.33C86.8187 238.515 93.8479 245.274 96.6153 253.527C98.5657 259.351 98.4997 265.63 99.4072 271.705L99.4198 271.809C100.278 277.422 102.662 282.701 106.254 287.091C107.279 288.347 108.286 289.61 109.271 290.89C114.632 297.893 119.287 305.806 120.386 314.554C121.502 323.449 118.595 332.86 112.338 339.275L112.345 339.287Z"
                        fill="url(#paint3_linear_28_1933)" />
                </g>
                <path
                    d="M105.473 546.107C105.437 545.856 105.285 545.727 105.049 545.648C104.45 545.454 103.856 545.236 103.26 545.033C102.909 544.912 102.729 545.005 102.607 545.358C101.669 548.074 100.729 550.794 99.7848 553.508C99.7034 553.744 99.7167 553.938 99.8675 554.125L102.397 554.999L105.471 546.103L105.473 546.107Z"
                    fill="url(#paint4_linear_28_1933)" />
                <path
                    d="M85.1687 534.349C85.3287 534.668 85.4955 534.986 85.6535 535.311C87.2883 538.672 88.9232 542.033 90.5551 545.393C90.6228 545.532 90.6869 545.654 90.8688 545.639C91.0933 544.198 92.1911 543.358 93.6192 543.546C93.8747 543.579 94.1266 543.67 94.3748 543.752C94.9517 543.945 95.5236 544.152 96.0986 544.341C96.1963 544.375 96.3319 544.374 96.4209 544.33C98.7065 543.228 100.986 542.114 103.268 541.004C103.303 540.988 103.333 540.966 103.381 540.94C103.344 540.86 103.313 540.782 103.277 540.708C102.667 539.458 102.053 538.207 101.45 536.956C101.064 536.153 101.276 535.297 101.959 534.828C102.302 534.593 102.659 534.526 103.046 534.718C103.557 534.972 104.083 535.051 104.631 534.854C105.333 534.601 105.768 534.095 105.895 533.366C106.038 532.55 105.767 531.855 105.113 531.346C103.81 530.329 102.184 531.209 102.002 532.526C101.955 532.867 101.745 533.11 101.428 533.255C100.682 533.599 99.806 533.341 99.3722 532.641C99.254 532.452 99.1639 532.247 99.0651 532.049C98.511 530.915 97.9598 529.782 97.4086 528.648C97.3747 528.579 97.3631 528.501 97.3362 528.401C96.5579 528.782 95.8365 529.138 95.1094 529.492C94.5486 529.765 93.986 530.033 93.4299 530.311C93.0451 530.503 92.8835 530.859 92.9812 531.247C93.0217 531.409 93.1005 531.507 93.2779 531.552C94.7097 531.924 95.3932 533.103 95.4772 534.127C95.6419 536.137 93.7856 537.644 91.8589 537.056C90.2907 536.575 89.4673 534.824 90.0532 533.221C90.1177 533.044 90.2291 532.88 90.0706 532.687C89.9026 532.484 89.7 532.362 89.4414 532.357C89.3164 532.355 89.1775 532.384 89.0654 532.439C87.7911 533.054 86.5187 533.673 85.2463 534.292C85.2269 534.301 85.2113 534.318 85.1677 534.352L85.1687 534.349Z"
                    fill="url(#paint5_linear_28_1933)" />
                <path
                    d="M98.9421 553.368L101.692 545.409C100.768 544.993 99.8273 544.78 98.8331 545.116C98.0464 545.381 97.2479 545.485 96.4324 545.303C96.0352 545.214 95.6531 545.072 95.2659 544.945C94.6957 544.761 94.1355 544.538 93.5562 544.39C92.7601 544.189 91.8839 544.723 91.7404 545.445C91.7221 545.535 91.726 545.627 91.723 545.719C91.7173 545.894 91.7941 545.988 91.9695 546.049C92.8347 546.348 93.7029 546.638 94.5523 546.973C95.3481 547.287 95.9321 547.878 96.4102 548.571C96.5324 548.748 96.4875 548.98 96.3322 549.113C96.1681 549.253 95.9258 549.247 95.7689 549.086C95.6918 549.011 95.6332 548.92 95.5697 548.834C95.1233 548.226 94.5383 547.815 93.8283 547.569C92.6354 547.157 91.4454 546.746 90.2585 546.317C90.018 546.23 89.7995 546.071 89.5935 545.913C87.5038 544.316 85.4199 542.711 83.334 541.112C82.8333 540.727 82.2419 540.892 82.0876 541.46C82.0134 541.74 82.1137 541.971 82.2884 542.183C83.4266 543.554 84.5609 544.927 85.6962 546.298C86.466 547.227 87.2378 548.15 87.9989 549.085C88.3823 549.559 88.8519 549.885 89.4307 550.082C92.515 551.138 95.5944 552.208 98.6758 553.273L98.9431 553.365L98.9421 553.368Z"
                    fill="url(#paint6_linear_28_1933)" />
                <path
                    d="M142.777 108.172C144.538 106.207 145.366 104.027 144.878 101.464C144.515 99.5318 143.516 97.9879 141.913 96.838C140.756 96.0087 139.467 95.5639 138.053 95.4884C136.621 95.4119 135.287 95.7411 134.036 96.4388C132.794 97.1316 131.917 98.185 131.105 99.3871C130.856 99.2001 130.626 99.0283 130.397 98.8564C128.48 97.4211 126.131 97.7545 124.625 99.6146C122.735 101.945 120.798 104.247 118.888 106.562C117.381 108.39 115.874 110.218 114.367 112.046C113.616 112.956 112.862 113.863 112.118 114.772C110.552 116.687 110.859 119.198 112.848 120.687C117.745 124.354 122.641 128.02 127.537 131.687C129.18 132.917 131.233 132.87 132.725 131.482C133.257 130.99 133.643 130.34 134.058 129.736C135.106 128.21 136.128 126.669 137.164 125.134C138.546 123.087 139.928 121.04 141.317 118.992C142.354 117.457 143.383 115.923 144.44 114.403C145.631 112.695 145.518 110.656 144.075 109.15C143.724 108.78 143.252 108.52 142.776 108.165L142.777 108.172ZM133.079 100.847C134.282 98.8968 135.893 97.6853 138.26 97.9734C140.298 98.2221 141.692 99.3909 142.324 101.342C142.994 103.41 142.25 105.133 140.851 106.666L133.075 100.843L133.079 100.847ZM139.395 111.984C138.997 112.507 138.208 112.611 137.694 112.207C137.172 111.797 137.073 111.022 137.475 110.502C137.884 109.982 138.665 109.878 139.18 110.282C139.702 110.692 139.799 111.453 139.395 111.984ZM128.405 103.723C128.802 103.193 129.575 103.083 130.103 103.478C130.63 103.873 130.733 104.652 130.336 105.181C129.948 105.699 129.151 105.816 128.637 105.419C128.109 105.017 128.004 104.25 128.405 103.723Z"
                    fill="url(#paint7_linear_28_1933)" />
                <path
                    d="M75.5085 273.903C72.2498 273.903 68.991 273.903 65.7377 273.903C64.9135 273.903 64.122 274.073 63.4124 274.526C62.6154 275.039 62.0696 275.743 61.7748 276.638C60.8087 279.537 59.8097 282.419 58.8818 285.328C57.6645 289.165 59.908 292.894 63.86 293.592C65.6777 293.914 67.3589 293.461 68.8545 292.359C68.9856 292.26 69.1111 292.151 69.2421 292.048C69.8971 291.524 70.5139 291.513 71.1526 292.037C72.5336 293.172 74.122 293.712 75.9015 293.614C77.3317 293.538 78.609 293.03 79.7334 292.135C80.5522 291.485 81.0599 291.485 81.8732 292.135C84.2476 294.013 87.5774 294.155 89.8809 292.479C92.1407 290.83 93.0195 287.976 92.097 285.17C91.1745 282.359 90.2357 279.553 89.2859 276.753C88.6636 274.913 87.2335 273.903 85.2738 273.898C82.0151 273.898 78.7563 273.898 75.5031 273.898L75.5085 273.903Z"
                    fill="url(#paint8_linear_28_1933)" />
                <path
                    d="M90.05 295.666C89.2422 295.879 88.5053 296.12 87.7575 296.261C85.4212 296.709 83.2378 296.251 81.2127 295.039C80.907 294.853 80.6941 294.859 80.3993 295.039C78.9201 295.945 77.2934 296.392 75.5685 296.403C73.7727 296.414 72.0805 295.945 70.5412 295C70.3174 294.864 70.1537 294.837 69.908 294.984C67.1897 296.66 64.3349 296.895 61.3599 295.748C61.2562 295.71 61.158 295.672 60.9997 295.612C60.9888 295.754 60.9669 295.868 60.9669 295.983C60.9669 299.597 60.956 303.216 60.9669 306.829C60.9724 308.822 62.1896 310.383 64.051 310.814C64.384 310.89 64.7333 310.929 65.0718 310.934C66.1908 310.95 67.3098 310.929 68.4233 310.945C68.7563 310.945 68.8491 310.847 68.8436 310.519C68.8272 308.876 68.8327 307.233 68.8436 305.59C68.8491 303.445 70.6231 301.665 72.7683 301.66C74.5915 301.66 76.4092 301.66 78.2323 301.66C80.3775 301.665 82.157 303.445 82.1625 305.585C82.1625 307.228 82.1734 308.871 82.1625 310.514C82.1625 310.83 82.2389 310.956 82.5773 310.945C83.9256 310.907 85.2793 310.945 86.6275 310.852C88.2979 310.743 89.8208 309.193 89.9736 307.533C90.0173 307.042 90.0446 306.545 90.0446 306.049C90.0501 302.735 90.0446 299.422 90.0446 296.114V295.666H90.05Z"
                    fill="url(#paint9_linear_28_1933)" />
                <path
                    d="M79.477 310.934C79.477 309.138 79.4879 307.37 79.477 305.601C79.4715 304.919 78.9093 304.362 78.227 304.357C76.4202 304.34 74.608 304.34 72.8012 304.357C72.1243 304.357 71.5566 304.924 71.5512 305.601C71.5348 307.37 71.5512 309.133 71.5512 310.934H79.4879H79.477Z"
                    fill="url(#paint10_linear_28_1933)" />
                <path
                    d="M114.554 207.283H78.238C78.4885 208.166 78.7331 209.031 78.9777 209.89C80.5346 215.295 82.0975 220.699 83.6425 226.104C83.7558 226.497 83.899 226.647 84.3344 226.641C92.3875 226.623 100.441 226.629 108.5 226.641C108.875 226.641 109.042 226.551 109.15 226.169C110.909 220.013 112.687 213.857 114.459 207.701C114.495 207.576 114.518 207.439 114.554 207.283V207.283ZM83.5649 211.298C83.6723 211.149 83.7856 210.851 83.9825 210.767C84.1853 210.678 84.5074 210.743 84.7281 210.851C84.8653 210.916 84.9488 211.161 84.9966 211.346C85.6706 214.012 86.3328 216.685 87.0009 219.351C87.2514 220.359 87.5079 221.361 87.7406 222.375C87.836 222.805 87.6272 223.121 87.2574 223.205C86.8637 223.294 86.5654 223.121 86.4223 222.709C86.3924 222.626 86.3745 222.536 86.3566 222.447C85.6706 219.721 84.9846 216.995 84.3046 214.269C84.066 213.32 83.8393 212.372 83.5768 211.304L83.5649 211.298ZM108.398 210.678C109.084 210.69 109.311 211.107 109.144 211.775C108.422 214.662 107.706 217.556 106.978 220.443C106.787 221.2 106.603 221.964 106.394 222.715C106.274 223.133 105.946 223.306 105.565 223.211C105.201 223.121 105.016 222.829 105.07 222.417C105.087 222.298 105.117 222.179 105.141 222.065C105.547 220.431 105.952 218.796 106.364 217.162C106.847 215.223 107.33 213.278 107.814 211.34C107.909 210.952 108.1 210.678 108.398 210.678V210.678ZM98.5734 222.56C98.7404 220.478 98.8895 218.605 99.0446 216.732C99.1878 214.961 99.3369 213.195 99.492 211.423C99.5338 210.916 99.8261 210.648 100.273 210.69C100.691 210.725 100.912 211.024 100.876 211.531C100.846 211.948 100.804 212.372 100.769 212.789C100.5 216.017 100.226 219.238 99.9514 222.465C99.9096 222.99 99.6352 223.264 99.2057 223.234C98.7822 223.205 98.5555 222.894 98.5674 222.566L98.5734 222.56ZM91.9759 212.014C91.9341 211.083 92.0415 210.821 92.3875 210.707C92.9005 210.54 93.2822 210.886 93.3359 211.531C93.503 213.589 93.6819 215.641 93.8489 217.699C93.9802 219.274 94.1174 220.848 94.2307 222.429C94.2665 222.918 93.9981 223.228 93.5865 223.246C93.1749 223.264 92.9005 222.984 92.8587 222.501C92.7573 221.343 92.6678 220.186 92.5664 219.035C92.3576 216.601 92.1548 214.173 91.9699 212.02L91.9759 212.014Z"
                    fill="url(#paint11_linear_28_1933)" />
                <path
                    d="M96.3903 201.742C89.6197 201.742 82.8492 201.742 76.0787 201.742C74.5576 201.742 73.5316 203.156 74.0625 204.528C74.3905 205.369 75.0408 205.798 75.9296 205.882C76.0191 205.888 76.1085 205.882 76.198 205.882C89.6615 205.882 103.131 205.882 116.594 205.882C117.155 205.882 117.668 205.762 118.11 205.404C118.79 204.85 119.046 203.931 118.76 203.12C118.462 202.273 117.704 201.736 116.791 201.736C111.303 201.736 105.815 201.736 100.327 201.736C99.0149 201.736 97.7026 201.736 96.3903 201.736V201.742Z"
                    fill="url(#paint12_linear_28_1933)" />
                <path
                    d="M104.032 200.358H104.539C106.71 200.358 108.881 200.352 111.053 200.364C111.363 200.364 111.536 200.268 111.697 200C112.967 197.864 114.041 195.645 114.447 193.176C114.59 192.311 114.614 191.398 114.495 190.533C114.292 189.03 113.301 188.451 111.816 188.839C110.396 189.209 109.233 190.044 108.136 190.974C106.609 192.269 105.338 193.796 104.205 195.442C104.121 195.562 104.038 195.711 104.038 195.848C104.026 197.321 104.032 198.801 104.032 200.352V200.358ZM109.985 198.592C109.776 198.538 109.663 198.532 109.579 198.479C108.583 197.834 107.581 197.196 106.609 196.522C106.298 196.307 106.274 195.955 106.507 195.639C106.728 195.335 107.05 195.216 107.378 195.419C108.368 196.039 109.358 196.671 110.307 197.357C110.474 197.477 110.552 197.882 110.492 198.115C110.438 198.318 110.14 198.461 109.991 198.598L109.985 198.592ZM110.695 196.158C110.516 196.128 110.444 196.134 110.402 196.105C109.699 195.651 108.977 195.216 108.303 194.715C108.046 194.524 108.07 194.166 108.267 193.891C108.458 193.623 108.756 193.474 109.054 193.653C109.734 194.059 110.408 194.488 111.041 194.971C111.196 195.09 111.255 195.478 111.184 195.687C111.112 195.896 110.832 196.033 110.701 196.158H110.695Z"
                    fill="url(#paint13_linear_28_1933)" />
                <path d="M82.7296 192.072V200.328H91.9935V192.072H82.7296Z" fill="url(#paint14_linear_28_1933)" />
                <path
                    d="M93.4196 200.334H102.624C102.636 200.179 102.648 200.048 102.648 199.916C102.648 197.638 102.648 195.359 102.648 193.086C102.648 192.317 102.361 192.03 101.58 192.03C99.2119 192.03 96.8437 192.03 94.4755 192.03C93.694 192.03 93.4196 192.311 93.4196 193.098C93.4196 195.359 93.4196 197.626 93.4196 199.886V200.34V200.334ZM100.811 196.331C100.811 197.846 99.5578 199.099 98.0486 199.105C96.5275 199.117 95.239 197.828 95.251 196.313C95.2569 194.774 96.5216 193.533 98.0665 193.551C99.5936 193.569 100.822 194.81 100.817 196.331H100.811Z"
                    fill="url(#paint15_linear_28_1933)" />
                <path
                    d="M78.0475 200.328H81.3045V199.863C81.3045 197.226 81.3104 194.584 81.2925 191.947C81.2925 191.696 81.2031 191.416 81.0718 191.201C80.6364 190.503 80.1591 189.829 79.664 189.102C79.1093 189.925 78.5843 190.688 78.0713 191.464C78.0117 191.553 78.0176 191.696 78.0176 191.816C78.0176 194.548 78.0176 197.274 78.0176 200.006C78.0176 200.107 78.0415 200.209 78.0534 200.334L78.0475 200.328Z"
                    fill="url(#paint16_linear_28_1933)" />
                <path
                    d="M80.9939 188.588C81.4413 189.245 81.8588 189.877 82.2943 190.503C82.342 190.575 82.4732 190.622 82.5627 190.622C85.4678 190.628 88.3788 190.622 91.3912 190.622C90.914 189.913 90.4845 189.268 90.0431 188.636C89.9894 188.564 89.8283 188.535 89.721 188.535C86.8696 188.535 84.0242 188.535 81.1728 188.535C81.1311 188.535 81.0953 188.559 80.9939 188.588V188.588Z"
                    fill="url(#paint17_linear_28_1933)" />
                <path d="M82.4974 185.379V187.133H87.5082V185.379H82.4974Z" fill="url(#paint18_linear_28_1933)" />
                <path d="M99.9216 190.599V189.167H96.1516V190.599H99.9216Z" fill="url(#paint19_linear_28_1933)" />
                <path
                    d="M99.4083 196.331C99.4142 195.556 98.8237 194.953 98.0542 194.947C97.2787 194.947 96.6702 195.526 96.6464 196.289C96.6285 197.059 97.2608 197.715 98.0303 197.721C98.77 197.721 99.4023 197.089 99.4083 196.331V196.331Z"
                    fill="url(#paint20_linear_28_1933)" />
                <path
                    d="M36.3816 121.666C36.6155 121.14 37.0165 120.952 37.5929 120.96C39.4392 120.985 41.2896 120.969 43.14 120.969C44.7273 120.969 45.9178 122.159 46.0264 123.738C46.1099 124.966 46.2895 126.19 46.4232 127.418C46.465 127.794 46.5067 128.17 46.5527 128.571H46.9787C53.875 128.571 60.7755 128.579 67.6718 128.558C68.5156 128.558 68.9291 129.151 68.7996 129.899C68.2942 132.744 67.8431 135.597 67.3669 138.441C67.2959 138.867 67.2374 139.297 67.133 139.715C66.8072 141.023 65.7086 141.875 64.3636 141.875C58.6285 141.875 52.8934 141.875 47.1542 141.875C46.6947 141.875 46.3188 142.004 46.1099 142.439C45.8259 143.032 46.2352 143.708 46.9119 143.775C47.0289 143.788 47.1458 143.779 47.2586 143.779C52.2251 143.779 57.1874 143.779 62.1539 143.779C63.7872 143.779 65.0361 145.049 65.0236 146.682C65.0152 148.094 63.8999 149.327 62.4923 149.473C61.047 149.627 59.6602 148.658 59.4013 147.246C59.3094 146.753 59.3887 146.227 59.3887 145.697H53.4782C53.7957 146.824 53.5952 147.831 52.7598 148.667C52.1499 149.272 51.3981 149.523 50.5418 149.477C49.2051 149.402 47.4215 148.015 48.0481 145.676C47.693 145.676 47.3505 145.676 47.0038 145.676C45.6504 145.672 44.4976 144.782 44.1927 143.512C43.8836 142.226 44.46 140.935 45.6504 140.308C45.8551 140.2 45.9178 140.087 45.8927 139.87C45.7298 138.454 45.5711 137.042 45.4124 135.626C45.2536 134.21 45.0991 132.794 44.9403 131.382C44.7816 129.945 44.6187 128.508 44.46 127.075C44.343 126.019 44.2177 124.958 44.1175 123.897C44.0548 123.233 43.6831 122.861 43.0106 122.861C41.2061 122.861 39.3974 122.844 37.5929 122.869C37.0165 122.877 36.6155 122.69 36.3816 122.163V121.658V121.666ZM49.8191 135.237C49.8191 135.826 49.8191 136.419 49.8191 137.008C49.8191 137.639 50.2243 138.086 50.7757 138.082C51.3187 138.078 51.7197 137.635 51.7197 137.029C51.7197 135.826 51.7239 134.623 51.7197 133.42C51.7197 132.815 51.3062 132.376 50.7631 132.38C50.2201 132.384 49.8233 132.827 49.8191 133.433C49.8191 134.034 49.8191 134.636 49.8191 135.237ZM57.4255 135.246C57.4255 134.644 57.4255 134.043 57.4255 133.441C57.4255 132.815 57.0078 132.368 56.4565 132.38C55.9134 132.393 55.525 132.831 55.5208 133.445C55.5208 134.636 55.5208 135.83 55.5208 137.021C55.5208 137.635 55.9134 138.074 56.4565 138.086C57.0078 138.099 57.4213 137.648 57.4213 137.021C57.4213 136.432 57.4213 135.839 57.4213 135.25L57.4255 135.246ZM61.2266 135.2C61.2266 135.81 61.2266 136.424 61.2266 137.033C61.2308 137.639 61.636 138.082 62.179 138.082C62.722 138.082 63.1272 137.639 63.1272 137.033C63.1272 135.83 63.1314 134.628 63.1272 133.425C63.1272 132.819 62.7178 132.376 62.1748 132.376C61.6318 132.376 61.2308 132.819 61.2266 133.425C61.2266 134.013 61.2266 134.607 61.2266 135.196V135.2Z"
                    fill="url(#paint21_linear_28_1933)" />
                <path
                    d="M57.4254 126.645C57.4254 125.029 57.4171 123.433 57.4296 121.842C57.4296 121.336 57.864 120.969 58.407 120.969C60.341 120.969 62.2708 120.969 64.2048 120.969C64.8063 120.969 65.4078 120.96 66.0093 120.969C66.5022 120.977 66.9199 121.361 66.9199 121.842C66.9324 123.433 66.924 125.029 66.924 126.645H57.4213H57.4254Z"
                    fill="url(#paint22_linear_28_1933)" />
                <path
                    d="M49.8191 126.645C49.8191 125.66 49.8108 124.699 49.8191 123.742C49.8233 123.299 50.2034 122.886 50.642 122.882C52.2543 122.865 53.8708 122.873 55.4999 122.873V126.645H49.8149H49.8191Z"
                    fill="url(#paint23_linear_28_1933)" />
                <path
                    d="M165.662 260.066C164.378 254.655 159.667 252.347 155.577 253.085C154.971 253.196 154.369 253.371 153.783 253.571C152.394 254.047 151.019 254.561 149.637 255.058C148.766 255.372 148.64 255.862 149.265 256.527C149.849 257.159 150.449 257.774 151.014 258.419C152.368 259.954 152.109 262.314 150.267 263.179C148.379 264.066 146.367 264.821 144.33 265.228C141.832 265.737 139.619 263.876 139.035 261.268C138.581 259.231 138.05 257.215 137.551 255.187C137.41 254.615 137.27 254.043 137.122 253.419C136.655 253.588 136.22 253.715 135.82 253.906C135.719 253.955 135.667 254.205 135.671 254.364C135.787 256.992 135.92 259.619 136.049 262.249C136.086 263.078 136.129 263.905 136.167 264.769C136.3 264.775 136.42 264.779 136.54 264.783C138.529 264.868 140.183 265.589 141.318 267.292C141.772 267.977 141.953 268.677 141.356 269.39C141.306 269.45 141.313 269.602 141.349 269.684C141.429 269.857 141.546 270.016 141.673 270.22L142.066 270.078C146.168 268.601 150.275 267.121 154.376 265.644C154.618 265.557 154.757 265.465 154.797 265.166C154.923 264.296 155.446 263.722 156.276 263.423C159.248 262.353 162.225 261.28 165.198 260.21L165.66 260.043L165.662 260.066ZM158.572 259.553C159.449 259.237 160.326 258.921 161.197 258.607C161.696 258.427 162.103 258.583 162.247 259C162.381 259.391 162.177 259.779 161.699 259.951C159.963 260.582 158.225 261.208 156.484 261.829C156.007 262.001 155.609 261.836 155.465 261.437C155.314 261.017 155.515 260.654 156.025 260.47C156.875 260.164 157.721 259.859 158.572 259.553ZM157.441 258.406C156.779 258.644 156.121 258.893 155.45 259.123C154.995 259.275 154.616 259.097 154.482 258.706C154.34 258.312 154.529 257.948 154.98 257.785C156.293 257.312 157.6 256.823 158.917 256.379C159.133 256.301 159.467 256.341 159.659 256.461C160.14 256.775 160.004 257.453 159.42 257.693C158.768 257.957 158.099 258.174 157.437 258.413L157.441 258.406Z"
                    fill="url(#paint24_linear_28_1933)" />
                <path
                    d="M152.961 252.342C153.11 252.294 153.257 252.259 153.399 252.208C156.996 250.912 160.594 249.617 164.191 248.321C165.01 248.026 165.126 247.771 164.831 246.951C163.864 244.268 162.9 241.589 161.933 238.906L161.77 238.454L159.712 239.196C159.793 239.422 159.883 239.638 159.952 239.863C160.069 240.236 159.908 240.597 159.576 240.746C159.254 240.891 158.858 240.761 158.675 240.418C158.553 240.195 158.473 239.957 158.359 239.689L152.934 241.643C152.991 241.801 153.057 241.984 153.121 242.163C153.285 242.65 153.12 243.083 152.717 243.216C152.325 243.346 151.944 243.127 151.77 242.662C151.709 242.493 151.647 242.32 151.577 242.126L149.55 242.856L152.966 252.34L152.961 252.342Z"
                    fill="url(#paint25_linear_28_1933)" />
                <path
                    d="M132.441 274.453C133.401 276.623 135.665 277.705 137.842 277.011C140.554 276.14 141.71 272.894 140.164 270.496C139.977 270.208 139.813 270.113 139.452 270.248C137.165 271.096 134.87 271.923 132.567 272.728C132.226 272.851 132.133 273.021 132.208 273.344C132.293 273.711 132.361 274.084 132.443 274.458L132.441 274.453Z"
                    fill="url(#paint26_linear_28_1933)" />
                <path
                    d="M164.094 262.168L163.679 262.317C161.41 263.134 159.141 263.951 156.873 264.769C156.211 265.007 156.04 265.371 156.314 266.002C157.294 268.26 159.846 269.251 162.099 268.291C164.111 267.436 165.193 264.922 164.393 262.801C164.317 262.591 164.202 262.402 164.088 262.17L164.094 262.168Z"
                    fill="url(#paint27_linear_28_1933)" />
                <path
                    d="M130.776 271.855L140.286 268.429C140.008 267.723 139.504 267.246 138.89 266.891C137.721 266.215 136.482 266.02 135.191 266.456C134.355 266.739 133.477 267.002 132.736 267.464C131.291 268.377 130.536 269.722 130.693 271.493C130.702 271.602 130.74 271.707 130.776 271.855V271.855Z"
                    fill="url(#paint28_linear_28_1933)" />
                <path
                    d="M161.259 237.037C161.093 236.574 160.946 236.135 160.779 235.703C160.632 235.328 160.28 235.159 159.892 235.251C159.783 235.278 159.682 235.326 159.572 235.366C156.137 236.603 152.698 237.842 149.263 239.079C148.491 239.357 148.359 239.648 148.635 240.433C148.754 240.764 148.874 241.094 149.006 241.462L161.263 237.047L161.259 237.037Z"
                    fill="url(#paint29_linear_28_1933)" />
                <path
                    d="M132.331 250.559L133.299 253.248C133.424 253.215 133.534 253.193 133.634 253.157C134.852 252.718 136.078 252.283 137.294 251.839C138.14 251.534 138.543 250.742 138.268 249.963C137.99 249.174 137.157 248.821 136.295 249.131C134.983 249.604 133.675 250.075 132.331 250.559Z"
                    fill="url(#paint30_linear_28_1933)" />
                <path
                    d="M151.585 252.855C151.398 252.336 151.253 251.883 151.074 251.438C150.915 251.062 150.599 250.909 150.214 251.041C149.373 251.326 148.538 251.627 147.711 251.949C147.217 252.144 146.98 252.705 147.119 253.206C147.268 253.734 147.776 254.091 148.315 253.974C148.767 253.876 149.202 253.702 149.64 253.55C150.277 253.326 150.911 253.092 151.588 252.848L151.585 252.855Z"
                    fill="url(#paint31_linear_28_1933)" />
                <path
                    d="M52.9659 496.37C55.5319 496.616 57.7677 495.621 59.9255 494.428C62.8292 492.821 65.3705 490.768 67.4792 488.185C71.8026 482.886 70.2557 475.121 64.6831 471.637C59.4696 468.374 52.4779 469.926 49.1996 475.125C49.1479 475.209 49.0709 475.283 49.0084 475.362L47.8278 478.197C47.7437 478.722 47.6387 479.248 47.5778 479.779C47.1547 483.376 47.5777 486.895 48.653 490.336C49.3224 492.474 50.1664 494.538 52.0231 495.981L52.968 496.375L52.9659 496.37ZM62.6976 482.842C61.7819 485.041 59.2416 486.099 57.0434 485.192C54.8539 484.285 53.7907 481.726 54.6963 479.531C55.6003 477.34 58.1616 476.282 60.3562 477.187C62.5508 478.093 63.6068 480.649 62.6925 482.844L62.6976 482.842Z"
                    fill="url(#paint32_linear_28_1933)" />
                <path
                    d="M86.3243 466.594C86.248 466.777 86.1882 466.921 86.1298 467.061C85.0704 469.605 84.0111 472.149 82.9481 474.691C82.6548 475.395 82.1899 475.711 81.5582 475.558C81.2795 475.488 80.9962 475.277 80.7977 475.056C79.9276 474.078 79.0787 473.079 78.2364 472.075C78.0843 471.894 77.9406 471.834 77.7046 471.853C76.4123 471.96 75.1208 472.055 73.8272 472.144C72.6638 472.225 72.0895 471.437 72.5363 470.354C73.584 467.819 74.6446 465.292 75.6995 462.759C75.7638 462.605 75.8282 462.45 75.903 462.271C75.7658 462.205 75.6661 462.151 75.5584 462.106C73.2446 461.142 70.9309 460.179 68.6172 459.215C67.9058 458.919 67.2655 459.171 66.9722 459.875C65.8215 462.638 64.6724 465.397 63.5217 468.16C63.4963 468.221 63.4795 468.281 63.4427 468.38C67.9983 470.277 70.9962 473.566 72.016 478.426C73.038 483.291 71.5421 487.47 68.0756 491.056L68.5175 491.24C73.0479 493.127 77.5784 495.014 82.1089 496.901C82.9891 497.267 83.5642 497.03 83.9293 496.154C87.3693 487.894 90.8108 479.631 94.2508 471.371C94.6069 470.516 94.3664 469.939 93.5078 469.582C91.2551 468.643 89.0024 467.705 86.7498 466.767C86.6205 466.713 86.4911 466.659 86.3258 466.591L86.3243 466.594Z"
                    fill="url(#paint33_linear_28_1933)" />
                <path
                    d="M75.3967 469.661C75.55 469.658 75.6757 469.66 75.7972 469.651C76.6322 469.59 77.4677 469.537 78.3021 469.468C78.7999 469.426 79.1931 469.586 79.5128 469.972C80.0509 470.613 80.5971 471.245 81.1433 471.878C81.225 471.975 81.3148 472.063 81.4295 472.182L84.1259 465.708L78.0864 463.193L75.3931 469.66L75.3967 469.661Z"
                    fill="url(#paint34_linear_28_1933)" />
                <path
                    d="M60.5257 481.934C60.947 480.912 60.4771 479.793 59.4481 479.368C58.4349 478.947 57.2956 479.425 56.8757 480.443C56.4588 481.454 56.935 482.588 57.9605 483.011C58.9772 483.435 60.1064 482.961 60.5257 481.934V481.934Z"
                    fill="url(#paint35_linear_28_1933)" />
                <path
                    d="M50.1804 403.464C50.4191 401.897 49.9415 400.572 48.8091 399.485C47.3058 398.043 44.8589 397.913 43.1685 399.171C43.0249 399.278 42.9203 399.229 42.8005 399.164C42.067 398.755 41.3349 398.343 40.6006 397.929C40.0402 397.615 39.4876 397.29 38.9215 396.989C38.4707 396.75 37.9866 396.75 37.4952 396.839C34.1302 397.449 30.7637 398.051 27.3979 398.657C27.2207 398.69 27.0406 398.718 26.8618 398.753C26.4251 398.836 26.2934 399.028 26.3759 399.461C26.8596 401.977 27.3427 404.489 27.828 407.002C27.9293 407.526 28.029 408.051 28.134 408.573C28.2119 408.949 28.4205 409.096 28.7963 409.028C32.3839 408.383 35.9731 407.735 39.5607 407.09C40.143 406.986 40.5933 406.697 40.9477 406.224C41.2443 405.827 41.5729 405.451 41.8877 405.065C41.9268 405.018 41.9772 404.979 42.0387 404.924C42.4639 405.582 42.9868 406.112 43.6966 406.522C43.754 406.199 43.82 405.921 43.8453 405.64C43.851 405.563 43.7516 405.468 43.6881 405.394C43.3871 405.04 43.0791 404.691 42.7774 404.332C42.6723 404.206 42.6853 404.094 42.8071 403.956C43.2113 403.494 43.5981 403.014 43.9857 402.538C44.5436 401.852 44.5583 400.764 44.0258 400.032C43.9798 399.967 43.9322 399.904 43.8847 399.841C44.699 399.11 46.309 399.026 47.5077 399.643C48.6995 400.257 49.4767 401.704 49.3224 403.049C49.2358 403.034 49.1499 403.022 49.0658 402.998C47.1299 402.519 45.151 403.351 44.1823 405.095C43.8492 405.693 43.8304 405.549 44.4371 405.854C44.927 406.1 45.4676 406.179 46.018 406.16C46.2793 406.151 46.4649 406.292 46.5193 406.531C46.5505 406.667 46.5056 406.864 46.4166 406.965C46.3308 407.06 46.1474 407.102 46.0036 407.111C45.2571 407.146 44.5717 406.975 43.739 406.568C43.7196 406.635 43.6919 406.7 43.6841 406.765C43.5304 408.242 43.8543 409.567 44.9299 410.648C45.0694 410.787 45.0561 410.919 45 411.089C44.0467 413.966 43.1042 416.847 42.1486 419.722C42.0621 419.985 42.0715 420.196 42.1965 420.44C42.4331 420.898 42.6403 421.37 42.8583 421.835C43.0055 422.144 43.0797 422.168 43.3829 422.02C43.8508 421.794 44.3217 421.573 44.7919 421.348C44.8326 421.289 44.8734 421.229 44.9142 421.17C44.7978 420.909 44.6939 420.639 44.5591 420.385C44.4392 420.158 44.4888 420.018 44.7101 419.901C44.926 419.787 45.1276 419.65 45.3435 419.536C45.5601 419.426 45.5898 419.275 45.4974 419.067C45.3892 418.828 45.2996 418.582 45.193 418.341C45.111 418.157 45.1572 418.031 45.3306 417.935C45.5668 417.801 45.7969 417.657 46.0338 417.527C46.211 417.43 46.2505 417.299 46.1776 417.122C46.0787 416.879 45.9945 416.63 45.877 416.395C45.7529 416.145 45.8318 415.991 46.0571 415.863C46.3095 415.721 46.5453 415.553 46.7985 415.414C47.0013 415.305 47.1178 415.15 47.1946 414.93C47.5391 413.944 47.9066 412.963 48.2511 411.977C48.3174 411.787 48.4176 411.705 48.6101 411.679C50.4544 411.43 51.6755 410.39 52.2293 408.643C52.7807 406.905 52.3376 405.358 51.0504 404.071C50.7987 403.821 50.4667 403.653 50.1714 403.447C50.0775 403.746 49.9927 404.05 49.8865 404.347C49.829 404.509 49.8174 404.629 49.9266 404.788C50.3643 405.428 50.2753 406.213 49.7292 406.769C49.2321 407.278 48.3948 407.382 47.7798 407.01C47.0756 406.587 46.7837 405.842 47.0334 405.107C47.2678 404.418 47.9754 403.969 48.7127 404.045C48.8079 404.054 48.9045 404.069 49.0188 404.084L49.2788 403.211L50.1759 403.461L50.1804 403.464ZM32.181 405.041C32.103 404.901 32.0159 404.807 31.992 404.7C31.7833 403.663 31.5838 402.622 31.3927 401.584C31.3497 401.353 31.452 401.175 31.6844 401.096C31.9074 401.02 32.1002 401.082 32.232 401.277C32.2847 401.356 32.3041 401.46 32.322 401.557C32.5051 402.499 32.686 403.439 32.8653 404.382C32.8804 404.463 32.9198 404.557 32.8897 404.621C32.8279 404.76 32.758 404.93 32.6395 405C32.521 405.07 32.3387 405.032 32.181 405.041V405.041ZM35.7379 400.427C35.8122 400.613 35.8888 400.746 35.9191 400.888C36.109 401.845 36.2896 402.805 36.4718 403.764C36.5362 404.11 36.4124 404.344 36.1397 404.399C35.8593 404.455 35.6466 404.276 35.5768 403.922C35.4819 403.444 35.3908 402.964 35.2997 402.485C35.205 401.987 35.1088 401.491 35.0164 400.994C34.9763 400.778 35.0205 400.577 35.2292 400.488C35.3714 400.428 35.5463 400.447 35.7386 400.431L35.7379 400.427Z"
                    fill="url(#paint36_linear_28_1933)" />
                <path
                    d="M49.0136 405.085C48.703 404.872 48.2486 404.956 48.0277 405.268C47.8209 405.56 47.9084 406.02 48.2113 406.234C48.518 406.448 48.9909 406.366 49.2071 406.061C49.4311 405.745 49.347 405.314 49.0159 405.087L49.0136 405.085Z"
                    fill="url(#paint37_linear_28_1933)" />
                <g opacity="0.3">
                    <path
                        d="M56.6429 46.7991C54.6202 46.7526 52.688 47.7339 51.1881 49.0919C49.6951 50.4497 48.5733 52.1651 47.4986 53.8728C45.1296 57.6266 42.9882 61.1027 41.0521 65.0813C40.253 66.7231 39.4898 68.8368 38.8744 70.5562C38.6756 71.1067 38.4906 71.6772 38.5186 72.2606C38.5465 72.844 38.8314 73.4496 39.356 73.703C39.942 73.9891 40.6769 73.7627 41.1682 73.3282C41.6562 72.8971 41.962 72.2973 42.2616 71.7179C44.7918 66.8541 48.1565 62.2108 52.9005 59.4589C54.2258 58.6881 55.6386 58.0811 56.9676 57.3271C58.3 56.5697 59.5751 55.6446 60.4491 54.3862C61.323 53.1277 61.751 51.4928 61.3012 50.0263C60.7077 48.0967 58.6586 46.839 56.636 46.7925L56.6429 46.7991Z"
                        fill="url(#paint38_linear_28_1933)" />
                    <path
                        d="M-21.6872 40.5311C-20.6322 41.6994 -19.0417 42.2704 -17.4699 42.3928C-15.9015 42.5119 -14.3307 42.2294 -12.7838 41.9236C-9.39091 41.2558 -6.27438 40.6068 -2.98627 39.5731C-1.6274 39.146 -0.0239864 38.4442 1.2782 37.8764C1.69325 37.6931 2.1181 37.4928 2.43255 37.1662C2.747 36.8397 2.93691 36.3535 2.80037 35.9173C2.64599 35.4307 2.12406 35.1401 1.62024 35.0922C1.11311 35.0477 0.613003 35.1954 0.122827 35.3329C-3.98624 36.5035 -8.417 37.0861 -12.514 35.8701C-13.6579 35.5304 -14.7605 35.0583 -15.9012 34.7084C-17.0419 34.3585 -18.2511 34.1348 -19.4291 34.3121C-20.6071 34.4895 -21.7628 35.1254 -22.3507 36.1625C-23.1279 37.5339 -22.7387 39.3661 -21.6837 40.5344L-21.6872 40.5311Z"
                        fill="url(#paint39_linear_28_1933)" />
                    <path
                        d="M-9.90326 97.9929C-9.46957 96.125 -3.061 101.76 -0.517554 105.415C2.02933 109.073 -2.72021 112.065 -5.97535 106.658C-9.23048 101.251 -10.031 98.5522 -9.89995 97.9895L-9.90326 97.9929Z"
                        fill="url(#paint40_linear_28_1933)" />
                    <path
                        d="M-43.6208 65.1729C-43.0088 58.2963 -38.8194 51.7576 -32.665 48.6281C-27.8245 46.1613 -22.2209 45.8402 -16.8502 44.9903C-8.93202 43.7382 -1.21299 41.241 5.93778 37.6136C12.5872 34.2454 18.882 25.534 26.2598 24.444C31.0998 23.7255 36.2366 24.5979 40.3245 27.2889C45.4445 30.656 48.4608 37.7009 48.4962 42.591C48.5698 52.5128 37.3584 62.5245 35.6301 72.2945C34.2311 80.2086 38.4838 86.4237 37.8563 94.4381C37.3319 101.128 32.8758 107.31 26.7826 110.108C20.6894 112.905 13.2016 112.293 7.53077 108.713C3.53037 106.186 0.511994 102.405 -2.98785 99.2201L-3.0463 99.1638C-6.29159 96.2308 -10.2852 94.24 -14.568 93.3685C-15.7913 93.118 -17.008 92.8539 -18.2183 92.5695C-24.8299 90.999 -31.4617 88.5413 -36.3772 83.8541C-41.3754 79.0874 -44.2226 72.0528 -43.6106 65.1761L-43.6208 65.1729Z"
                        fill="url(#paint41_linear_28_1933)" />
                </g>
            </g>
            <defs>
                <linearGradient id="paint0_linear_28_1933" x1="16.1312" y1="276.227" x2="14.5049" y2="262.746"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint1_linear_28_1933" x1="57.4723" y1="352.314" x2="54.5734" y2="328.284"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint2_linear_28_1933" x1="106.79" y1="278.542" x2="104.528" y2="259.791"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint3_linear_28_1933" x1="63.2413" y1="351.261" x2="49.592" y2="238.119"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint4_linear_28_1933" x1="104.171" y1="545.345" x2="101.001" y2="554.517"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint5_linear_28_1933" x1="97.4541" y1="528.442" x2="91.4353" y2="545.862"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint6_linear_28_1933" x1="92.334" y1="542.145" x2="89.5748" y2="550.131"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint7_linear_28_1933" x1="142.066" y1="96.9504" x2="120.18" y2="126.177"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint8_linear_28_1933" x1="75.5046" y1="273.898" x2="75.5046" y2="293.694"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint9_linear_28_1933" x1="75.5061" y1="294.885" x2="75.5061" y2="310.946"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint10_linear_28_1933" x1="75.5159" y1="304.344" x2="75.5159" y2="310.934"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint11_linear_28_1933" x1="96.3961" y1="207.283" x2="96.3961" y2="226.641"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint12_linear_28_1933" x1="96.3981" y1="201.736" x2="96.3981" y2="205.884"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint13_linear_28_1933" x1="109.3" y1="188.722" x2="109.3" y2="200.364"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint14_linear_28_1933" x1="87.3615" y1="192.072" x2="87.3615" y2="200.328"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint15_linear_28_1933" x1="98.0337" y1="192.03" x2="98.0337" y2="200.34"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint16_linear_28_1933" x1="79.6614" y1="189.102" x2="79.6614" y2="200.334"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint17_linear_28_1933" x1="86.1926" y1="188.535" x2="86.1926" y2="190.625"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint18_linear_28_1933" x1="85.0028" y1="185.379" x2="85.0028" y2="187.133"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint19_linear_28_1933" x1="98.0366" y1="189.167" x2="98.0366" y2="190.599"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint20_linear_28_1933" x1="98.0272" y1="194.947" x2="98.0272" y2="197.721"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint21_linear_28_1933" x1="52.6023" y1="120.96" x2="52.6023" y2="149.489"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint22_linear_28_1933" x1="62.174" y1="120.965" x2="62.174" y2="126.645"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint23_linear_28_1933" x1="52.6574" y1="122.871" x2="52.6574" y2="126.645"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint24_linear_28_1933" x1="146.492" y1="250.035" x2="152.374" y2="266.365"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint25_linear_28_1933" x1="155.657" y1="240.656" x2="159.081" y2="250.161"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint26_linear_28_1933" x1="136.007" y1="271.489" x2="137.979" y2="276.964"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint27_linear_28_1933" x1="160.069" y1="263.617" x2="161.795" y2="268.409"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint28_linear_28_1933" x1="134.31" y1="266.753" x2="135.531" y2="270.142"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint29_linear_28_1933" x1="154.405" y1="237.222" x2="155.137" y2="239.254"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint30_linear_28_1933" x1="135.053" y1="249.579" x2="136.032" y2="252.296"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint31_linear_28_1933" x1="148.815" y1="251.533" x2="149.555" y2="253.587"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint32_linear_28_1933" x1="63.067" y1="470.799" x2="52.4971" y2="496.179"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint33_linear_28_1933" x1="81.1128" y1="464.419" x2="69.7318" y2="491.746"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint34_linear_28_1933" x1="81.1061" y1="464.451" x2="78.4098" y2="470.925"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint35_linear_28_1933" x1="59.4571" y1="479.372" x2="57.9443" y2="483.005"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint36_linear_28_1933" x1="44.848" y1="396.701" x2="32.4224" y2="414.803"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint37_linear_28_1933" x1="49.0148" y1="405.086" x2="48.2215" y2="406.241"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04F485" />
                    <stop offset="1" stop-color="#0DCB72" />
                </linearGradient>
                <linearGradient id="paint38_linear_28_1933" x1="44.5272" y1="55.9698" x2="52.0625" y2="63.2261"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint39_linear_28_1933" x1="-17.2045" y1="30.6751" x2="-3.77239" y2="43.6098"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint40_linear_28_1933" x1="-10.725" y1="98.7334" x2="-0.243503" y2="108.827"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
                <linearGradient id="paint41_linear_28_1933" x1="-20.1357" y1="34.1133" x2="43.1072" y2="95.0143"
                    gradientUnits="userSpaceOnUse">
                    <stop stop-color="#04B061" />
                    <stop offset="1" stop-color="#22FF98" />
                </linearGradient>
            </defs>
        </svg>

    </section>
    <!-- ==== Contact Section ==== -->
@endsection
@if(isset($recaptcha) && $recaptcha['status'] == 1)
    <script src="https://www.google.com/recaptcha/api.js?render={{$recaptcha['site_key']}}"></script>
@endif
@if(isset($recaptcha) && $recaptcha['status'] == 1)
    <script>
        $(document).ready(function() {
            $('#signInBtn').click(function (e) {
                e.preventDefault();
                if (typeof grecaptcha === 'undefined') {
                    toastr.error('Invalid recaptcha key provided. Please check the recaptcha configuration.');
                    return;
                }
                grecaptcha.ready(function () {
                    grecaptcha.execute('{{$recaptcha['site_key']}}', {action: 'submit'}).then(function (token) {
                        $('#g-recaptcha-response').value = token;
                        $('#form-id').submit();
                    });
                });
                window.onerror = function (message) {
                    var errorMessage = 'An unexpected error occurred. Please check the recaptcha configuration';
                    if (message.includes('Invalid site key')) {
                        errorMessage = 'Invalid site key provided. Please check the recaptcha configuration.';
                    } else if (message.includes('not loaded in api.js')) {
                        errorMessage = 'reCAPTCHA API could not be loaded. Please check the recaptcha API configuration.';
                    }
                    toastr.error(errorMessage)
                    return true;
                };
            });
        });
    </script>
@endif
{{-- recaptcha scripts end --}}
